<?php
// login_erro.php (RAIZ)

// Sessão
if (session_status() === PHP_SESSION_NONE) {
    session_start();
}

header('Content-Type: text/html; charset=utf-8');

// Escape helper
function h($s) { return htmlspecialchars($s, ENT_QUOTES, 'UTF-8'); }

// ===== Parâmetros =====
// err: auth|user|password|404|forbidden
$err = isset($_GET['err']) ? strtolower(trim($_GET['err'])) : 'auth';

// para onde voltar após o aviso (ex.: /login.php)
$back = $_GET['back'] ?? '/login.php';

// evita open-redirect (aceita apenas caminhos locais)
if (filter_var($back, FILTER_VALIDATE_URL) || !preg_match('#^(/|\.?/)$#', '/') && !preg_match('#^(/|\.?/).+#', $back)) {
    $back = '/login.php';
}

$redirect_time = 8;

// ===== Mensagens e status =====
$status_code   = 401;
$error_title   = 'Credenciais inválidas';
$error_message = 'Usuário e/ou senha incorretos. Verifique os dados digitados e tente novamente.';

switch ($err) {
    case 'user':
        $status_code   = 401;
        $error_title   = 'Usuário não encontrado';
        $error_message = 'Não localizamos uma conta com esse usuário. Verifique e tente novamente.';
        break;
    case 'password':
        $status_code   = 401;
        $error_title   = 'Senha incorreta';
        $error_message = 'A senha informada não confere para este usuário. Verifique e tente novamente.';
        break;
    case 'forbidden':
        $status_code   = 403;
        $error_title   = 'Acesso proibido';
        $error_message = 'Você não tem permissão para acessar este recurso.';
        break;
    case '404':
        $status_code   = 404;
        $error_title   = 'Página não encontrada';
        $error_message = 'O recurso solicitado não foi localizado. Verifique o endereço ou retorne à página anterior.';
        break;
    case 'auth':
    default:
        $status_code   = 401;
        $error_title   = 'Credenciais inválidas';
        $error_message = 'Usuário e/ou senha incorretos. Verifique os dados digitados e tente novamente.';
        break;
}

http_response_code($status_code);
$page_title = $error_title . ' - Star 3D Midia';
$index_url  = '/index.php'; // botão VOLTAR (ícone) vai para a Index
?>
<!DOCTYPE html>
<html lang="pt-BR">
<head>
<meta charset="utf-8">
<meta name="viewport" content="width=device-width, initial-scale=1">
<meta name="author" content="Star 3D Midia IBO P2P">
<title><?= h($page_title) ?></title>

<!-- Bootstrap -->
<link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/css/bootstrap.min.css" rel="stylesheet">
<!-- Font Awesome -->
<link href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.5.2/css/all.min.css" rel="stylesheet">
<!-- Google Fonts -->
<link href="https://fonts.googleapis.com/css2?family=Poppins:wght@300;400;500;600;700&display=swap" rel="stylesheet">

<style>
:root{
  --primary:#8000FF;
  --primary-dark:#6200E6;
  --error:#FF5757;
  --bg:#121212;
  --card:rgba(30,30,40,.9);
  --text:#f8f9fa;
}
*{box-sizing:border-box;margin:0;padding:0}
html,body{height:100%}
body{
  font-family:'Poppins',sans-serif;
  background: var(--bg);
  color:var(--text);
  min-height:100vh;
  display:flex;align-items:center;justify-content:center;
  padding:20px; position:relative;
  background-image:
    radial-gradient(circle at 25% 25%, rgba(128,0,255,.18) 0%, transparent 50%),
    radial-gradient(circle at 75% 75%, rgba(255,87,87,.18) 0%, transparent 50%);
}
#particles-js{position:fixed;inset:0;z-index:-1}
.card-erro{
  background:var(--card);
  border:1px solid rgba(255,255,255,.08);
  backdrop-filter: blur(10px);
  -webkit-backdrop-filter: blur(10px);
  border-radius:16px;
  box-shadow:0 8px 32px rgba(0,0,0,.3);
  padding:2.25rem;
  width:100%;max-width:560px;
  text-align:center;animation:fade .45s ease-out;
}
@keyframes fade{from{opacity:0;transform:translateY(18px)}to{opacity:1;transform:none}}
.icon{
  font-size:4.5rem;color:var(--error);margin-bottom:1rem;animation:pulse 1.5s infinite;
}
@keyframes pulse{0%{transform:scale(1)}50%{transform:scale(1.07)}100%{transform:scale(1)}}
.title{font-size:1.9rem;font-weight:700;color:var(--error);margin-bottom:.75rem}
.msg{font-size:1.05rem;opacity:.95}
.muted{font-size:.95rem;opacity:.75;margin-top:1rem}
.count{font-weight:700;color:var(--primary)}
.btn-primary{
  background:var(--primary);border:none;border-radius:12px;padding:12px 18px;
  font-weight:600;
}
.btn-primary:hover{background:var(--primary-dark);transform:translateY(-2px)}
.btn-outline-light{
  border:1px solid rgba(255,255,255,.25); color:#fff; border-radius:12px; padding:12px 16px;
}
.btn-outline-light:hover{background:rgba(255,255,255,.1)}
.btns{display:flex;gap:.75rem;flex-wrap:wrap;justify-content:center;margin-top:1.1rem}
.brand{margin-top:1.75rem;padding-top:1.1rem;border-top:1px solid rgba(255,255,255,.12);opacity:.8}
@media (max-width:480px){
  .icon{font-size:3.6rem}
  .title{font-size:1.5rem}
}
</style>
</head>
<body>
<div id="particles-js"></div>

<div class="card-erro">
  <div class="icon"><i class="fas fa-exclamation-triangle"></i></div>
  <h1 class="title"><?= h($error_title) ?></h1>
  <p class="msg"><?= h($error_message) ?></p>

  <p class="muted">
    Redirecionando em <span class="count"><?= (int)$redirect_time ?></span> segundos…
  </p>

  <div class="btns">
    <!-- Tentar novamente (volta para o back/login) -->
    <a class="btn btn-primary" href="<?= h($back) ?>">
      <i class="fas fa-rotate-left me-1"></i> Tentar novamente
    </a>

    <!-- VOLTAR com ícone (vai para Index) -->
    <a class="btn btn-outline-light" href="<?= h($index_url) ?>">
      <i class="fas fa-arrow-left me-1"></i> Voltar ao Início
    </a>
  </div>

  <div class="brand">P2PLAY APPS &copy; 2025</div>
</div>

<script src="https://cdn.jsdelivr.net/particles.js/2.0.0/particles.min.js"></script>
<script>
document.addEventListener('DOMContentLoaded', function () {
  particlesJS('particles-js', {
    "particles":{"number":{"value":60,"density":{"enable":true,"value_area":800}},
      "color":{"value":"#FF5757"},
      "shape":{"type":"circle","stroke":{"width":0,"color":"#000"}},
      "opacity":{"value":0.5},"size":{"value":3,"random":true},
      "line_linked":{"enable":true,"distance":120,"color":"#FF5757","opacity":0.3,"width":1},
      "move":{"enable":true,"speed":1.5,"out_mode":"out"} },
    "interactivity":{"detect_on":"canvas","events":{"onhover":{"enable":true,"mode":"grab"},"onclick":{"enable":true,"mode":"push"},"resize":true}}
  });

  // Contador + redirecionamento
  var secs = <?= (int)$redirect_time ?>;
  var el = document.querySelector('.count');
  var timer = setInterval(function(){
    secs--; if (el) el.textContent = secs;
    if (secs <= 0) { clearInterval(timer); window.location.href = <?= json_encode($back) ?>; }
  }, 1000);
});
</script>
</body>
</html>
