<?php
declare(strict_types=1);
session_start();

// (Opcional) se já logado, vai direto pro painel
if (!empty($_SESSION['loggedin'])) {
  header('Location: dns.php');
  exit;
}

// Logo do mesmo DB do login (fallback em img/logo.png)
$LOGO = 'img/logo.png';
try {
  if (is_file('./a/.eggziepanels.db')) {
    $db  = new SQLite3('./a/.eggziepanels.db');
    $row = $db->query('SELECT LOGO FROM USERS WHERE id=1')->fetchArray(SQLITE3_ASSOC);
    if ($row && !empty($row['LOGO'])) $LOGO = $row['LOGO'];
  }
} catch (Throwable $e) { /* usa fallback */ }

$ano = date('Y');
?>
<!doctype html>
<html lang="pt-BR">
<head>
  <meta charset="utf-8">
  <meta name="viewport" content="width=device-width, initial-scale=1">
  <title>IBO VS4 by P2PLAY</title>

  <!-- Favicons -->
  <link rel="apple-touch-icon" sizes="180x180" href="img/apple-touch-icon.png">
  <link rel="icon" type="image/png" sizes="32x32" href="img/favicon-32x32.png">
  <link rel="icon" type="image/png" sizes="16x16" href="img/favicon-16x16.png">
  <link rel="manifest" href="img/site.webmanifest">
  <meta name="theme-color" content="#121212">

  <!-- Bootstrap + Font -->
  <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css" rel="stylesheet">
  <link href="https://fonts.googleapis.com/css2?family=Poppins:wght@300;400;500;600;700&display=swap" rel="stylesheet">

  <style>
    :root{
      --primary:#8000FF;         /* roxo do login */
      --primary-dark:#6200E6;
      --accent:#FF9100;          /* laranja do login */
      --bg:#121212;
      --card:rgba(30,30,40,.9);
      --text:#f8f9fa;
      --muted:rgba(255,255,255,.8);
      --stroke:rgba(255,255,255,.08);
    }
    *{box-sizing:border-box}
    html,body{height:100%}
    body{
      margin:0; font-family:'Poppins',sans-serif; color:var(--text);
      background-color:var(--bg);
      background-image:
        radial-gradient(circle at 25% 25%, rgba(128, 0, 255, .20) 0%, transparent 50%),
        radial-gradient(circle at 75% 75%, rgba(255,145, 0, .20) 0%, transparent 50%);
      display:flex; align-items:center; justify-content:center; padding:16px;
      position:relative; overflow:hidden;
    }

    /* fundo partículas (igual login) */
    #js-particles{position:fixed; inset:0; z-index:-1}

    .wrap{width:100%; display:flex; justify-content:center}
    .card-glass{
      width:clamp(340px, 66vw, 860px);              /* ~2/3 da tela */
      background:var(--card);
      border:1px solid var(--stroke);
      border-radius:16px;
      box-shadow:0 8px 32px rgba(0,0,0,.2);
      backdrop-filter: blur(10px);
      -webkit-backdrop-filter: blur(10px);
      padding:clamp(20px, 4vw, 36px);
    }

    .logo{
      display:block; margin:0 auto 8px auto; width:100%; max-height:150px; object-fit:contain;
    }
    .title{
      text-align:center; font-weight:800; letter-spacing:.4px;
      font-size:clamp(24px, 4.2vw, 36px); margin:4px 0 12px;
      background:linear-gradient(135deg, var(--primary), var(--accent));
      -webkit-background-clip:text; background-clip:text; color:transparent;
    }

    /* MARQUEE — linha única, rolando indefinidamente */
    .marquee-wrap{
      position:relative; overflow:hidden;
      border:1px solid var(--stroke); border-radius:12px;
      background:rgba(255,255,255,.04);
      padding:8px 0; margin:12px 0 18px;
    }
    .marquee-track{
      display:inline-block; white-space:nowrap;
      will-change:transform;
      animation: ticker 30s linear infinite;
      padding-left: 100%;           /* entra da direita */
    }
    .marquee-item{
      display:inline-flex; align-items:center; gap:8px;
      color:var(--muted); font-weight:600; margin:0 22px;
    }
    .marquee-item .ok{font-size:1.05rem}
    @keyframes ticker{
      0%   { transform: translateX(0) }
      100% { transform: translateX(-50%) } /* como repetimos os itens, -50% fecha o loop */
    }
    @media (prefers-reduced-motion:reduce){ .marquee-track{ animation:none } }

    .btn-cta{
      display:inline-flex; gap:.6rem; align-items:center; justify-content:center;
      padding:14px 22px; border-radius:12px; width:100%; font-weight:700; text-transform:uppercase;
      background:linear-gradient(90deg, var(--accent), var(--primary)); border:none; color:#fff;
      box-shadow:0 8px 24px rgba(128,0,255,.25);
      transition:.15s transform ease, .15s filter ease;
    }
    .btn-cta:hover{ transform:translateY(-1px); filter:brightness(1.05) }

    .mini{ text-align:center; color:var(--muted); margin-top:16px; font-size:.95rem }
  </style>
</head>
<body>
  <div id="js-particles"></div>

  <div class="wrap">
    <div class="card-glass">
      <img class="logo" src="<?= htmlspecialchars($LOGO) ?>" alt="Logo">
      <div class="title">IBO VS4</div>

      <!-- PONTOS DESLIZANDO (linha única) -->
      <div class="marquee-wrap" role="region" aria-label="Recursos do painel rolando">
        <div class="marquee-track">
  <span class="marquee-item"><span class="ico">👤➕</span> Adicionar usuários por login/senha</span>
  <span class="marquee-item"><span class="ico">🖥️</span> Adicionar usuários via MAC</span>
  <span class="marquee-item"><span class="ico">🖼️</span> Trocar logo diretamente pelo painel</span>
  <span class="marquee-item"><span class="ico">🌌</span> Alterar fundo do aplicativo</span>
  <span class="marquee-item"><span class="ico">📢</span> Enviar anúncios</span>
  <span class="marquee-item"><span class="ico">🔳</span> Gerenciar QR Code</span>
  <span class="marquee-item"><span class="ico">🎨</span> Trocar tema do aplicativo</span>
  <span class="marquee-item"><span class="ico">🔔</span> Enviar notificações push para o app</span>
  <span class="marquee-item"><span class="ico">🌐∞</span> Utilização de DNS ilimitado</span>

  <!-- repetição para loop perfeito -->
  <span class="marquee-item" aria-hidden="true"><span class="ico">👤➕</span> Adicionar usuários por login/senha</span>
  <span class="marquee-item" aria-hidden="true"><span class="ico">🖥️</span> Adicionar usuários via MAC</span>
  <span class="marquee-item" aria-hidden="true"><span class="ico">🖼️</span> Trocar logo diretamente pelo painel</span>
  <span class="marquee-item" aria-hidden="true"><span class="ico">🌌</span> Alterar fundo do aplicativo</span>
  <span class="marquee-item" aria-hidden="true"><span class="ico">📢</span> Enviar anúncios</span>
  <span class="marquee-item" aria-hidden="true"><span class="ico">🔳</span> Gerenciar QR Code</span>
  <span class="marquee-item" aria-hidden="true"><span class="ico">🎨</span> Trocar tema do aplicativo</span>
  <span class="marquee-item" aria-hidden="true"><span class="ico">🔔</span> Enviar notificações push para o app</span>
  <span class="marquee-item" aria-hidden="true"><span class="ico">🌐∞</span> Utilização de DNS ilimitado</span>
</div>
      </div>

      <a href="login.php" class="btn-cta">
        <svg xmlns="http://www.w3.org/2000/svg" width="18" height="18" fill="currentColor" viewBox="0 0 16 16"><path d="M6 3.5a.5.5 0 0 0-1 0V7H2.5a.5.5 0 0 0 0 1H5v3.5a.5.5 0 0 0 1 0V8h3.5a.5.5 0 0 0 0-1H6V3.5z"/><path d="M13 14.5A1.5 1.5 0 0 0 14.5 13V3A1.5 1.5 0 0 0 13 1.5H8a.5.5 0 0 0 0 1h5a.5.5 0 0 1 .5.5v10a.5.5 0 0 1-.5.5H8a.5.5 0 0 0 0 1h5z"/></svg>
        Iniciar sessão
      </a>

      <div class="mini">© <?= $ano ?> P2PLAY APPS — Todos os direitos reservados.</div>
    </div>
  </div>

  <!-- Lib: particles (mesmo do login) -->
  <script src="https://cdn.jsdelivr.net/particles.js/2.0.0/particles.min.js"></script>
  <script>
    document.addEventListener('DOMContentLoaded', function() {
      if (typeof particlesJS !== 'undefined') {
        particlesJS('js-particles', {
          "particles": {
            "number": { "value": 60, "density": { "enable": true, "value_area": 800 } },
            "color": { "value": "#8000FF" },
            "shape": { "type": "circle", "stroke": { "width": 0, "color": "#000000" } },
            "opacity": { "value": 0.5 }, "size": { "value": 3, "random": true },
            "line_linked": { "enable": true, "distance": 120, "color": "#8000FF", "opacity": 0.3, "width": 1 },
            "move": { "enable": true, "speed": 1.5, "out_mode": "out" }
          },
          "interactivity": {
            "detect_on": "canvas",
            "events": { "onhover": { "enable": true, "mode": "grab" }, "onclick": { "enable": true, "mode": "push" }, "resize": true },
            "modes": { "grab": { "distance": 120, "line_linked": { "opacity": 0.8 } }, "push": { "particles_nb": 3 } }
          },
          "retina_detect": true
        });
      }
      const resize = () => {
        const c = document.querySelector('#js-particles canvas');
        if (c){ c.style.width='100%'; c.style.height='100%'; }
      };
      window.addEventListener('resize', resize); resize();
    });
  </script>
</body>
</html>


