<?php
$auto_background = true;
$tmdb_api_key = 'SUA_CHAVE_DE_API';
$tmdb_language = 'pt-BR';

function getTmdbBackground() {
    global $tmdb_api_key, $tmdb_language;
    
    try {
        // Buscar filmes populares
        $url = "https://api.themoviedb.org/3/movie/popular?api_key={$tmdb_api_key}&language={$tmdb_language}";
        $response = @file_get_contents($url);
        
        if ($response === false) {
            throw new Exception("Falha ao acessar API TMDB");
        }
        
        $data = json_decode($response, true);
        
        if (isset($data['results']) && count($data['results']) > 0) {
            $movies = $data['results'];
            $randomMovie = $movies[array_rand($movies)];
            
            if (!empty($randomMovie['backdrop_path'])) {
                return 'https://image.tmdb.org/t/p/original' . $randomMovie['backdrop_path'];
            }
        }
    } catch (Exception $e) {
        error_log("Erro TMDB: " . $e->getMessage());
    }
    
    // Fallback padrão
    return 'https://image.tmdb.org/t/p/original/wwemzKWzjKYJFfCeiB57q3r4Bcm.png';
}
?>